<?php if(isset($inventario_suficiente)): ?>
    <?php if(!$inventario_suficiente): ?>
        <div id="fraccionAlert" class="alert alert-warning" role="alert">
            Algunas partidas ya no cuentan con el inventario señalado en la OC. Se mostrará el valor restante en esas partidas.
        </div>
    <?php endif; ?>
<?php endif; ?>
<table class="table table-sm table-bordered table-hover">
    <thead>
        <tr>
            <th scope="col" style="text-align:center"><i class="fas fa-check-square"></i></th>
            <th scope="col" style="text-align:center">Entrada #</th>
            <th scope="col" style="text-align:center">Fecha</th>
            <th scope="col" style="text-align:center">Número_de_parte</th>
            <th scope="col" style="text-align:center">Piezas</th>
            <th scope="col" style="text-align:center">Bultos</th>
            <th scope="col" style="text-align:center">Tipo_bulto</th>
            <th scope="col" style="text-align:center">Peso_neto</th>
            <th scope="col" style="text-align:center">Peso_bruto</th>
            <th scope="col" style="text-align:center; min-width:200px;">Description</th>
            <th scope="col" style="text-align:center">PO</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $aux_income = "";
        $tr_color = "table-secondary";
        
        ?>
        <?php $__currentLoopData = $inventory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php 
            $is_first = false;
            if($aux_income != $row->income_id)
            {
                $aux_income = $row->income_id;
                $is_first = true;
                if ($tr_color == "")
                {
                    $tr_color = "table-secondary";
                }
                else
                {
                    $tr_color = "";
                }
            }
        ?>
        <tr id="inv_row_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" class="<?php echo e($tr_color); ?>">
            <td>
                <div class="btn-group" role="group" aria-label="Basic checkbox toggle button group">
                    <input type="checkbox" class="chkSingle income_<?php echo e($row->income_id); ?> btn-check" id="btncheck_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" autocomplete="off" onchange="selectRow('<?php echo e($row->id); ?>','<?php echo e($loop->index); ?>')">
                    <label class="btn btn-outline-success btn-sm" for="btncheck_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>"><i class="far fa-check-square"></i></label>
                    <?php if($is_first): ?>
                    <input type="checkbox" class="chkGroup btn-check" id="btncheckAll_<?php echo e($row->id); ?>_<?php echo e($row->income_id); ?>" autocomplete="off" onchange="selectGroup(this,'<?php echo e($row->income_id); ?>')">
                    <label class="btn btn-outline-primary btn-sm" for="btncheckAll_<?php echo e($row->id); ?>_<?php echo e($row->income_id); ?>"><i class="fas fa-tasks"></i></label>
                    <?php endif; ?>
                </div>
            </td>
            <td><?php echo e($row->income->getIncomeNumber()); ?><input type="hidden" id="txtIncomeRowId_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" name="income_row_id[]" value="<?php echo e($row->id); ?>"></td>
            <td class="oversized"><?php echo e(explode(' ',$row->income->cdate)[0]); ?></td>
            <td><?php echo e($row->part_number()->part_number); ?> <input type="hidden" name="txtNumeroDePartePesoU_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" id="txtNumeroDePartePesoU_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" value="<?php echo e($row->part_number()->unit_weight); ?>"></td>
            <td class="oversized">
                <input type="number" class="form-control" id="txtCantidad_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" name="units[]" value="<?php echo e($row->units); ?>" max="<?php echo e($row->units); ?>" min="0" onchange="validarCantidad(this,<?php echo e($row->units); ?>,'<?php echo e($loop->index); ?>')" readonly>
                <!-- <?php echo e($row->ump); ?> -->
                <input type="hidden" id="txtUM_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" name="ump[]" value="<?php echo e($row->ump); ?>">
            </td>
            <td><input type="number" class="form-control" id="txtBultos_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" name="bundles[]" value="<?php echo e($row->bundles); ?>" min="0" readonly onchange="calcularPesoBruto(<?php echo e($row->id); ?>,'<?php echo e($loop->index); ?>')"></td>
            <td>
                <select class="form-select" id = "txtUMB_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" name = "umb[]" disabled onchange="tipoBultoChange(<?php echo e($row->id); ?>,'<?php echo e($loop->index); ?>')">
                    <?php 
                    $peso_bulto = 0;
                    foreach ($tipos_de_bulto as $tipos_de_bultoOp)
                    {
                        $selected = "";
                        if($row->umb === $tipos_de_bultoOp->desc)
                        {
                            $selected = "selected";
                            $peso_bulto = $tipos_de_bultoOp->weight;
                        }
                        echo "<option value='".$tipos_de_bultoOp->desc."' ".$selected." >".$tipos_de_bultoOp->desc."</option>";
                    }
                    ?>
                </select>
                <?php
                echo "<input type='hidden' name='txtUMBPeso_".$row->id."' id='txtUMBPeso_".$row->id."_".$loop->index."' value='".$peso_bulto."'>";
                ?>
            </td>
            <td><input type="number" class="form-control" id="txtPesoNeto_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" min="0" name="net_weight[]" value="<?php echo e($row->part_number()->unit_weight * $row->units); ?>" readonly  onchange="calcularPesoBruto(<?php echo e($row->id); ?>,'<?php echo e($loop->index); ?>')"></td>
            <td><input type="number" class="form-control" id="txtPesoBruto_<?php echo e($row->id); ?>_<?php echo e($loop->index); ?>" min="0" name="gross_weight[]" value="<?php echo e($row->gross_weight); ?>" readonly></td>
            <td style="font-size: 0.9em;"><?php echo e($row->desc_ing); ?></td>
            <td><?php echo e($row->po); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>





<?php /**PATH /Users/juanjacobo/Documents/GitHub/goDaddy/ecexv2/ecex-portal/resources/views/intern/salidas/tblGetInventory.blade.php ENDPATH**/ ?>