<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDF</title>
<style type="text/css">
@import  url('http://fonts.cdnfonts.com/css/libre-barcode-39-text');
    .barcode
    {
        font-family: "Libre Barcode 39";
    }
    /* .barcode
    {
        font-family: "Arial";
    } */
    body
    {
        font-family: Arial, Helvetica, sans-serif;
    }
    .bold
    {	
        font-weight: bold;
    }
    .page_break { page-break-before: always; }
    footer {
                position: relative;  
                top: 5px; 
                left: 0px; 
                right: 0px;

                text-align: center;
            }
            @page  {
            margin: 50px 20px 3px 20px !important;
            padding: 0px 0px 0px 0px !important;
        }
</style>
</head>
<body>
<div style="margin-top: 0px; padding: 0px">
    <table style="position:relative; top: -30px; " >
    <tbody>
    <tr>
        <td width="50">
            <img class="box" src="<?php echo e(public_path('storage/images/logo.png')); ?>" style="left: 0px; top: -30px; width:120px;">
        </td>
		<td width="500" >
            <table width="500" class="arial" style=" font-size: 15px; " >
                <tbody>
                    <tr>
                        <td nowrap="nowrap" width="50%" style="text-align: left; " ><a  class="bold">Cliente: </a><?php echo e($income->customer->name); ?></td>
                        <td nowrap="nowrap" width="50%" style="text-align: left; " ><a class="bold" style="text-align: left;  ">Impo/Expo: </a><?php echo e($income->impoExpo); ?></td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap" width="50%" style="text-align: left; "><a class="bold" style="text-align: left;">Transportista: </a><?php echo e($income->carrier->name); ?></td>
                        <td nowrap="nowrap" width="50%"><a class="bold" style="text-align: left; ">Proveedor: </a><?php echo e($income->supplier->name); ?> </td>
                    </tr>
                </tbody>
            </table>
            <table width="500" class="arial" style="margin-top: 20px; font-size: 13px; text-align: left;" >
                <tbody>
                    <tr>
                        <td width="40%" style="text-align: left"><a class="bold" style="">Factura:</a> <?php echo e($income->invoice); ?></td>
                        <td width="40%"><a class="bold" style="">Sello:</a> <?php echo e($income->seal); ?></td>
                        <td width="20%"><a class="bold">Caja:</a> <?php echo e($income->trailer); ?></td>
                    </tr>
                    <tr>
                        <td with="40%"><a class="bold">Referencia:</a> <?php echo e($income->reference); ?></td>
                        <td width="40%"><a class="bold">Tracking:</a> <?php echo e($income->tracking); ?></td>
                        <td width="20%"></td>
                    </tr>
                </tbody>
            </table>
		</td>
        <td width="170">
            <table style="margin 0 auto; text-align: center;">
                <tbody >
                    <?php if($income->urgent): ?>
                    <tr>
                        <td class="time">
                            <strong>* Urgente *</strong> 
                        </td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td class="time" style="font-size: 20px;">
                            Entrada: <strong><?php echo e($income->getIncomeNumber()); ?></strong> 
                        </td>
                    </tr>
                    <tr>
                        <td class="barcode" style="font-size:37px;">
                            *<?php echo e($income->getIncomeNumber()); ?>*
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Fecha: <?php echo e(date("m/d/Y",strtotime($income->cdate))); ?>

                        </td>
                    </tr>
                    <tr>
                        <td>
                            <?php echo e($income->type); ?>

                        </td>
                    </tr>

                    
                </tbody>

            </table>
	    </td>
		
    </tr>
    </tbody>
    </table>




</div>
<hr width="100%">
<!--de aqui hasta el siguiente comentario!-->
<?php
$break = 4;
$pages = 1;
$it = 0;
foreach ($income->income_rows as $income_row) 
{
  $it++;
  if ($it % $break == 0)
  {
    $pages++;
    $it = 0;
  }
}

$page = 1;
?>
<?php $__currentLoopData = $income->income_rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $income_row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div>
<table width="100%" style="font-size: 10px; " class="arial"  >
  <tbody>
    <tr  style="    background: #eee;">
      <th height="" width="10%" scope="col"><?php echo e(utf8_encode($loop->iteration)); ?> No. Parte</th>
      <th scope="col" width="10%">Cantidad</th>
      <th scope="col" width="10%">Bultos</th>
      <th scope="col" width="20%">Peso Nt: Lbs/Kg</th>
      <th scope="col" width="20%">Peso Bt: Lbs/kg</th>
      <th scope="col" width="10%">Pais</th>
      <th scope="col" width="10%">Fraccion-Nico</th>
      <th scope="col" width="10%">PO</th>
    </tr>
    <tr style="">
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->part_number()->part_number)); ?></td>
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->units * 1)); ?>  <?php echo e(utf8_encode($income_row->ump)); ?></td>
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->bundles)); ?> <?php echo e(utf8_encode($income_row->umb)); ?></td>
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->net_weight * 1)); ?> Lbs / <?php echo e(utf8_encode(round($income_row->net_weight *  0.453592,2,PHP_ROUND_HALF_UP ))); ?> Kg</td>
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->gross_weight * 1)); ?> Lbs / <?php echo e(utf8_encode(round($income_row->gross_weight *  0.453592,2,PHP_ROUND_HALF_UP ))); ?> Kg</td>
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->origin_country)); ?></td>
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->fraccion)); ?>-<?php echo e(utf8_encode($income_row->nico)); ?></td>
      <td style="text-align:center"><?php echo e(utf8_encode($income_row->po)); ?></td>
    </tr>
  </tbody>
</table>
<table class="arial" width="100%" style=" font-size: 11px"  >
  <tbody>
    <tr style="background: #eee; ">
      <th height="" scope="col" width="30%">Desc Ing</th>
      <th scope="" width="30%%">Desc Esp</th>

      <th scope="" width="40%">Obeservaciones</th>
    </tr>
    <tr >
      <td><?php echo e(utf8_encode($income_row->desc_ing)); ?></td>
      <td><?php echo e(utf8_encode($income_row->desc_esp)); ?></td>
      <td><?php echo e(utf8_encode($income_row->observations)); ?></td>
    </tr>
  </tbody>
</table>

<table class="arial" width="100%" style=" font-size: 11px"  >
  <tbody>
    <tr style="background: #eee; ">
        <th height="" scope="col" width="20%">Locacion</th>
        <th height="" scope="col" width="20%">Marca</th>
        <th scope="" width="20%%">Modelo</th>
        <th scope="" width="20%">Serie</th>
        <th scope="" width="20%">Imex</th>
    </tr>
    <tr>
        <td><?php echo e(utf8_encode($income_row->location)); ?></td>
        <td><?php echo e(utf8_encode($income_row->brand)); ?></td>
        <td><?php echo e(utf8_encode($income_row->model)); ?></td>
        <td><?php echo e(utf8_encode($income_row->serial)); ?></td>
	    <td><?php echo e(utf8_encode($income_row->imex)); ?></td>
    </tr>
  </tbody>
</table>
<?php if($page != 1): ?>
<br>
<?php endif; ?>
</div>
<hr  width="100%" style="border-top: 1px solid	" size="3">

<?php if($loop->iteration % $break == 0): ?>

<footer style="text-align:center; font-size: small">
    Usuario: <?php echo e(utf8_encode($income->user)); ?> - page: <?php echo e(utf8_encode($page)); ?> of <?php echo e(utf8_encode($pages)); ?>

</footer>
<div class="page_break"></div>
<?php
$page++;
?>
<?php endif; ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<!-- y aqui se  duplica en caso de mas de 1 partida-->


  <table width="1000px" style="" >							
  <tbody>
    <tr>
      <td><b class="arial bold" style="font-size: small; ">Observaciones:</b> <p class="arial" style="font-size: small"> <?php echo e($income->observations); ?></p></td>
    </tr>
  </tbody>
</table>
<table class="arial" width="1000px" style="font-size: small">
    <tr>
        <td><strong> Peso Neto </strong></td>
        <td><strong> Peso Bruto </strong></td>
        <td><strong> Piezas UM </strong></td>
        <td><strong> Bultos UM </strong></td>
    </tr>
    <tr>
        <td id="tdPesoNeto"><?php echo e($income->getPesoNeto()); ?> lbs / <?php echo e(round( $income->getPesoNeto() * 0.453592,2,PHP_ROUND_HALF_EVEN)); ?> kg</td>
        <td id="tdPesoBruto"><?php echo e($income->getPesoBruto()); ?> lbs / <?php echo e(round( $income->getPesoBruto() * 0.453592,2, PHP_ROUND_HALF_EVEN)); ?> kg</td>
        <td id="tdPiezas"><?php echo str_replace("<br>","<br>",$income->getPiezasSum()); ?></td>
        <td id="tdBultos"><?php echo str_replace("<br>","<br>",$income->getBultosSum()); ?></td>
    </tr>
    <tr>
        <td id="tdPesoNeto"> </td>
        <td id="tdPesoBruto"> </td>
        <td id="tdPiezas"> <strong>Total:</strong> <?php echo str_replace("<br>","<br>",$income->getPiezasTotalSum()); ?></td>
        <td id="tdPiezas"> <strong>Total:</strong> <?php echo str_replace("<br>","<br>",$income->getBultosTotalSum()); ?></td>
    </tr>
</table>

<br>
<footer style="text-align:center; font-size: small">
    Usuario: <?php echo e($income->user); ?> - page: <?php echo e($page); ?> of <?php echo e($pages); ?>

</footer>


</body>
</html><?php /**PATH /Users/juanjacobo/Documents/GitHub/goDaddy/ecexv2/ecex-portal/resources/views/intern/entradas/pdf.blade.php ENDPATH**/ ?>